 <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register | GuruKool Hub</title>

    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Font Awesome for Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

    <!-- Custom CSS -->
    <style>
        body {
            background: linear-gradient(135deg, #317c81, #a31660);
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            padding: 10px;
            margin: 0;
        }
        .container {
            max-width: 360px;
            padding: 20px;
            background: #ffffff;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.2);
            border-radius: 10px;
            text-align: center;
        }
        .form-control {
            border-radius: 6px;
            border: 1px solid #a31660;
            font-size: 14px;
            padding: 6px;
        }
        .btn-primary {
            background: #a31660;
            border: none;
            border-radius: 6px;
            font-size: 14px;
            padding: 8px;
        }
        .btn-primary:disabled {
            background-color: #ccc;
            cursor: not-allowed;
        }
        .btn-primary:hover:not(:disabled) {
            background: #8c124f;
        }
        .logo {
            display: block;
            margin: 0 auto 15px;
            max-width: 80px;
            height: auto;
        }
        a {
            color: #317c81;
            font-size: 13px;
            font-weight: bold;
        }
        a:hover {
            color: #a31660;
        }
        .text-center p {
            font-size: 13px;
        }
        .input-group-text {
            cursor: pointer;
            background: #fff;
            border: 1px solid #a31660;
            border-radius: 6px;
        }
        .is-valid {
            border-color: #28a745;
        }
        .is-invalid {
            border-color: #dc3545;
        }
    </style>
</head>
<body>

<div class="container">
    <!-- Logo -->
    <img src="<?php echo e(asset('logo.png')); ?>" onerror="this.onerror=null; this.src='https://via.placeholder.com/80x80?text=Logo'" alt="GuruKool Logo" class="logo">

    <h4 class="mb-3" style="color: #a31660; font-weight: bold;">Create an Account</h4>
    
    <?php if($errors->any()): ?>
        <div class="alert alert-danger p-2 text-center">
            <ul class="mb-0" style="font-size: 12px; padding-left: 10px;">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('register')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <div class="mb-2">
            <input type="text" class="form-control" name="username" placeholder="Username" required value="<?php echo e(old('username')); ?>">
        </div>

        <div class="mb-2">
            <input type="email" class="form-control" name="email" placeholder="Email" required value="<?php echo e(old('email')); ?>">
        </div>

        <div class="mb-2">
            <input type="hidden" class="form-control" name="phone" value="8630293886" required>
        </div>

        <!-- Password -->
        <div class="mb-2">
            <div class="input-group">
                <input type="password" class="form-control" name="password" id="passwordInput" placeholder="Password" required>
                <span class="input-group-text" onclick="togglePassword('passwordInput', 'toggleIcon1')">
                    <i id="toggleIcon1" class="fa fa-eye"></i>
                </span>
            </div>
        </div>

        <!-- Confirm Password -->
        <div class="mb-2">
            <div class="input-group">
                <input type="password" class="form-control" name="password_confirmation" id="confirmPasswordInput" placeholder="Confirm Password" required>
                <span class="input-group-text" onclick="togglePassword('confirmPasswordInput', 'toggleIcon2')">
                    <i id="toggleIcon2" class="fa fa-eye"></i>
                </span>
            </div>
        </div>

        <!-- Math Captcha -->
        <div class="mb-2">
            <label class="form-label" style="font-size: 13px;">
                Solve: <strong><?php echo e(session('captcha_num1') ?? 0); ?> + <?php echo e(session('captcha_num2') ?? 0); ?> = ?</strong>
            </label>
            <input type="text" class="form-control" name="captcha_answer" id="captchaAnswer" required>
        </div>

        <!-- Hidden expected value -->
        <input type="hidden" id="captchaExpected" value="<?php echo e(session('captcha_num1') + session('captcha_num2')); ?>">

        <!-- Submit -->
        <button id="registerBtn" type="submit" class="btn btn-primary w-100" disabled>Register</button>

        <div class="text-center mt-2">
            <p><a href="<?php echo e(route('login')); ?>">Already have an account? Login</a></p>
        </div>
    </form>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<!-- JS: Show/Hide Password + Captcha Validation -->
<script>
    function togglePassword(inputId, iconId) {
        const passwordField = document.getElementById(inputId);
        const toggleIcon = document.getElementById(iconId);
        if (passwordField.type === "password") {
            passwordField.type = "text";
            toggleIcon.classList.remove("fa-eye");
            toggleIcon.classList.add("fa-eye-slash");
        } else {
            passwordField.type = "password";
            toggleIcon.classList.remove("fa-eye-slash");
            toggleIcon.classList.add("fa-eye");
        }
    }

    document.addEventListener("DOMContentLoaded", function () {
        const captchaInput = document.getElementById('captchaAnswer');
        const registerBtn = document.getElementById('registerBtn');
        const expected = parseInt(document.getElementById('captchaExpected').value);

        captchaInput.addEventListener('input', function () {
            const entered = parseInt(this.value);
            if (entered === expected) {
                registerBtn.disabled = false;
                this.classList.remove("is-invalid");
                this.classList.add("is-valid");
            } else {
                registerBtn.disabled = true;
                this.classList.remove("is-valid");
                this.classList.add("is-invalid");
            }
        });
    });
</script>

</body>
</html>
<?php /**PATH /home/yxq9qmneoal1/public_html/novartistraining.gurukoolhub.com/resources/views/auth/register.blade.php ENDPATH**/ ?>