<?php
use App\Models\FormDraft;

$formData = FormDraft::where('user_id', auth()->id())
->where('form_id', 'form5')
->where('case_id', $case_no)

->first();

$savedScores = [];

if ($formData) {
$decoded = json_decode($formData->form_data, true);
$savedScores = $decoded ?? [];
}
?>

<form id="form5" class="scoring-form" data-form-id="form5">
<input type="hidden" name="scores[total_activity_score]" id="total-activity-score-hidden">
<input type="hidden" name="scores[total_damage_score]" id="total-damage-score-hidden">

    <br>
    <hr>
 
    
    <div class="table-container">
        <table class="table table-striped table-bordered mediaTable table-1">
            <thead>
                <tr class="section-1-sub">
                    <th colspan="5"
                        style="border: 1px solid black; padding: 15px; text-align: center; font-size: 18px; color: #000;">
                       <strong> Gottron’s – Hands</strong>
                    </th>
                </tr>
                <tr>
                    <th colspan="2"
                        style="border: 1px solid black; padding: 12px; text-align: left; font-size: 16px; color: #000;">
                        Examine the patient’s hands and double score if papules are present
                    </th>
                    <th style="background-color: #4a4a4a; width: 15px; border: 1px solid black;"></th>
                    <th colspan="2"
                        style="border: 1px solid black; padding: 12px; text-align: left; font-size: 16px; color: #000;">
                        Examine patient’s hands and score if damage is present
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr style="background: linear-gradient(90deg, #F8EDE3, #E6CCB2);">
                    <td class="alltext" style="border: 1px solid black; padding: 12px; font-weight: bold; color: #000;">
                        0 - absent <br> 1 - pink; faint erythema <br> 2 - red erythema <br> 3 - dark red
                    </td>
                    <td style="border: 1px solid black; padding: 12px; text-align: center;">
                        <div class="radio-container-vertical">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[erythema]" value="<?php echo e($val); ?>" <?php echo e(isset($savedScores['scores']['erythema']) &&
                                    $savedScores['scores']['erythema']==$val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[erythema]" value="radio">
                        </div>
                        <div style="margin-top:10px;">
                            <label>Doubled Score (Read Only):</label>
                            <input type="text" name="scores[erythema_final_score]" id="erythema_final_score"
                                class="form-control" readonly
                                value="<?php echo e(isset($savedScores['scores']['erythema_final_score']) ? $savedScores['scores']['erythema_final_score'] : ''); ?>">
                            <input type="hidden" name="input_types[erythema_final_score]" value="readonly">
                        </div>


                    </td>
                    <td style="background-color: #4a4a4a; width: 15px;"></td>
                    <td class="alltext" style="border: 1px solid black; padding: 12px; font-weight: bold; color: #000;">
                        0 - absent <br> 1 - dyspigmentation <br> 2 - scarring
                    </td>
                    <td style="border: 1px solid black; padding: 12px; text-align: center;">
                        <div class="radio-container-vertical">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[damage]" value="<?php echo e($val); ?>" <?php echo e(isset($savedScores['scores']['damage']) && $savedScores['scores']['damage']==$val
                                    ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[damage]" value="radio">
                        </div>
                    </td>
                </tr>

                
                <tr style="text-align: center; background: linear-gradient(90deg, #F8EDE3, #E6CCB2);">
                    <td class="alltext"
                        style="border: 1px solid black; padding: 12px; text-align: left; font-size: 18px;">
                        Papule Present
                    </td>
                    <td style="border: 1px solid black; padding: 12px;">
                        <div style="display: flex; flex-direction: column; align-items: center;">
                            <label>
                                <input type="radio" name="scores[papule_present]" value="yes" <?php echo e(isset($savedScores['scores']['papule_present']) &&
                                    $savedScores['scores']['papule_present']=='yes' ? 'checked' : ''); ?>>
                                Yes
                            </label>
                            <label style="margin-top: 5px;">
                                <input type="radio" name="scores[papule_present]" value="no" <?php echo e(isset($savedScores['scores']['papule_present']) &&
                                    $savedScores['scores']['papule_present']=='no' ? 'checked' : ''); ?>>
                                No
                            </label>
                        </div>
                        <input type="hidden" name="input_types[papule_present]" value="radio">
                    </td>
                    <td style="background-color: #4a4a4a;" colspan="3"></td>
                </tr>
            </tbody>
        </table>
    </div>

    
    <br>
    <hr>
    <hr>
    <div class="table-container">
        <table class="table table-striped table-bordered mediaTable table-1"  id="activity-table">
            <thead>
                <tr class="section-1-sub">
                    <th colspan="2"
                        style="border: 1px solid black; padding: 15px; text-align: center; font-size: 18px;">Periungual
                    </th>
                </tr>
                <tr style="background: linear-gradient(90deg, #F8EDE3, #E6CCB2);">
                    <th colspan="2" style="border: 1px solid black; padding: 12px; text-align: left; color: #000;">
                       <strong> Periungual changes (examine)</strong>
                    </th>
                </tr>
            </thead>
            <tbody> 
                <tr style="background: linear-gradient(90deg, #F8EDE3, #E6CCB2);">
                    <td class="alltext" style="border: 1px solid black; padding: 12px;">
                        0 - absent <br> 1 - pink/red erythema / microscopic telangiectasias<br> 2 - visible
                        telangiectasias
                    </td>
                    <td style="border: 1px solid black; padding: 12px;">
                        <div class="radio-container-vertical">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[periunguals]" value="<?php echo e($val); ?>" <?php echo e(isset($savedScores['scores']['periunguals']) &&
                                    $savedScores['scores']['periunguals']==$val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[periunguals]" value="radio">
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    
    <br>
    <hr>
    <div class="table-container">
        <table class="table table-striped table-bordered mediaTable table-1"  id="activity-table">
            <thead>
                <tr class="section-1-sub">
                    <th colspan="3"
                        style="border: 1px solid black; padding: 15px; text-align: center; font-size: 18px;"><strong>Alopecia</strong>
                    </th>
                </tr>
                <tr style="background: linear-gradient(90deg, #F8EDE3, #E6CCB2);">
                    <th colspan="2" style="border: 1px solid black; padding: 12px; text-align: left;">Recent Hair loss
                        (within last 30 days as reported by the patient)</th>
                    <th style="background-color: #4a4a4a; width: 15px;"></th>
                </tr>
            </thead>
            <tbody>
                <tr style="background: linear-gradient(90deg, #F8EDE3, #E6CCB2);">
                    <td class="alltext" style="border: 1px solid black; padding: 12px;">0 - absent <br> 1 - present</td>
                    <td style="border: 1px solid black; padding: 12px;">
                        <div class="radio-container-vertical">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[alopecias]" value="<?php echo e($val); ?>" <?php echo e(isset($savedScores['scores']['alopecias']) &&
                                    $savedScores['scores']['alopecias']==$val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[alopecias]" value="radio">
                        </div>
                    </td>
                    <td style="background-color: #4a4a4a;"></td>
                </tr>
            </tbody>
        </table>
    </div>

    
    <br><br>
    <div class="table-container">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th colspan="2"
                        style="text-align: center; font-size: 24px; background: linear-gradient(135deg, #317c81, #a31660, #ff5f6d); color: white; border-radius: 8px;">
                        🔍 <strong>Overall Score Summary</strong>
                    </th>
                </tr>
            </thead>
            <tbody>
                
                <tr>
                    <td style="background-color: #f0f9ff; border: 2px solid #007bff; font-size: 16px; padding: 15px;">
                        <div style="font-weight: bold; color: #003366; margin-bottom: 8px;">
                            <span
                                style="background: linear-gradient(to right, #00c6ff, #0072ff); color: white; padding: 6px 14px; border-radius: 25px;">
                                Total Activity Score
                            </span>
                        </div>
                        <div style="font-size: 14px; color: #333;">
                            (Add scores from Erythema, Scale, Excoriation, Ulceration, Gottron's, Periungual, Alopecia)
                        </div>
                    </td>
                    <td id="total-activity-score"
                        style="background-color: #d6f0ff; border: 2px solid #007bff; text-align: center; font-size: 30px; font-weight: bold; color: #003366;">
                        <?php echo e(isset($savedScores['scores']['total_activity_score']) ?
                        $savedScores['scores']['total_activity_score'] : 0); ?>

                    </td>
                </tr>

                
                <tr>
                    <td style="background-color: #fff0f0; border: 2px solid #dc3545; font-size: 16px; padding: 15px;">
                        <div style="font-weight: bold; color: #660000; margin-bottom: 8px;">
                            <span
                                style="background: linear-gradient(to right, #ff6a6a, #dc3545); color: white; padding: 6px 14px; border-radius: 25px;">
                                Total Damage Score
                            </span>
                        </div>
                        <div style="font-size: 14px; color: #333;">
                            (Add scores from Poikiloderma, Calcinosis)
                        </div>
                    </td>
                    <td id="total-damage-score"
                        style="background-color: #ffe6e6; border: 2px solid #dc3545; text-align: center; font-size: 30px; font-weight: bold; color: #660000;">
                        <?php echo e(isset($savedScores['scores']['total_damage_score']) ?
                        $savedScores['scores']['total_damage_score'] : 0); ?>

                    </td>
                </tr>
            </tbody>
        </table>
    </div>


    <!--  <div class="text-center" style="margin-top: 20px;">
        <button type="button" class="btn btn-success save-btn" data-form-id="form5">📝 Save Draft</button>
        <span class="save-success-msg text-success" style="margin-left: 15px; font-weight: bold; display: none;">
            ✔ Draft saved successfully
        </span>
    </div> -->
</form><?php /**PATH /home/yxq9qmneoal1/public_html/novartistraining.gurukoolhub.com/resources/views/doctors/forms/form5.blade.php ENDPATH**/ ?>