

<?php $__env->startSection('content'); ?>
<br><br><br>

<div class="container-fluid">

    <!-- ✅ Success Message -->
    <?php if(session('success')): ?>
    <div class="alert alert-success text-center">
        <strong><i class="glyphicon glyphicon-ok-circle"></i> Success! </strong> <?php echo e(session('success')); ?>

    </div>
    <?php endif; ?>

    <!-- ✅ Dashboard Header -->
    <div class="text-center mb-4">
        <h2 style="color: #ff5f6d; font-weight: bold;">
            <i class="glyphicon glyphicon-dashboard"></i> Admin Dashboard
        </h2>
    </div>

    <!-- ✅ Quick Action Buttons -->
    <div class="row text-center">
        <div class="col-md-6">
            <a href="<?php echo e(route('documents.create')); ?>" class="btn btn-primary btn-lg shadow-box">
                <i class="glyphicon glyphicon-cloud-upload"></i> Upload a New Case
            </a>
        </div>
        <div class="col-md-6">
            <a href="<?php echo e(route('documents.list')); ?>" class="btn btn-info btn-lg shadow-box">
                <i class="glyphicon glyphicon-eye-open"></i> View All Cases
            </a>
        </div>
    </div>

    <br>

    <!-- ✅ Cases Management Table -->
    <div class="card">
        <div class="card-header bg-primary text-white">
            <h4><i class="glyphicon glyphicon-folder-open"></i> Cases Management</h4>
        </div>
        <div class="card-body">
            <table class="table table-bordered">
                <thead class="table-dark text-center">
                    <tr>
                        <th>Case Title</th>
                        <th>View Uploaded Case</th>
                        <th>Assign</th>
                        <th>Assigned Users</th>
                        <th>Unassign</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $assignedCases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $case): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($case->title); ?></td>

                        <!-- ✅ View Uploaded Case -->
                        <td class="text-center">
                            <?php if($case->file_path): ?>
                            <a href="<?php echo e(route('documents.view', $case->id)); ?>" target="_blank"
                                class="btn btn-sm btn-info">
                                <i class="glyphicon glyphicon-file"></i> 📄 View Case File
                            </a>
                            <?php else: ?>
                            <span class="text-danger">No File Uploaded</span>
                            <?php endif; ?>
                        </td>



                        <td class="text-center">
                            <a href="<?php echo e(route('documents.assignForm', $case->id)); ?>" class="btn btn-sm btn-success">
                                <i class="glyphicon glyphicon-user"></i> Assign
                            </a>
                        </td>

                        <!-- ✅ Assigned Users -->
                        <td>
                            <ul class="list-unstyled">
                                <?php $__currentLoopData = $case->users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>👤 <?php echo e($user->username); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </td>

                        <!-- ✅ Unassign Users -->
                        <td>
                            <?php $__currentLoopData = $case->users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <button class="btn btn-sm btn-danger unassign-btn" data-user-id="<?php echo e($user->id); ?>"
                                data-document-id="<?php echo e($case->id); ?>">
                                ❌ <?php echo e($user->username); ?>

                            </button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <?php echo e($assignedCases->links()); ?>

        </div>
    </div>

</div>

<!-- ✅ Unassign Confirmation Modal -->
<div class="modal fade" id="unassignModal" tabindex="-1">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header bg-danger">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="glyphicon glyphicon-exclamation-sign"></i> Confirm Unassign</h4>
            </div>
            <div class="modal-body text-center">
                Are you sure you want to unassign this user?
            </div>
            <div class="modal-footer">
                <form id="unassignForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-danger">Unassign</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- ✅ JavaScript for Unassign Confirmation -->
<script>
$(document).ready(function() {
    $('.unassign-btn').click(function() {
        var userId = $(this).data('user-id');
        var documentId = $(this).data('document-id');

        // Update form action dynamically
        $('#unassignForm').attr('action', '/admin/documents/unassign/' + documentId + '/' + userId);
        $('#unassignModal').modal('show');
    });
});
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yxq9qmneoal1/public_html/novartistraining.gurukoolhub.com/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>