<?php
use App\Models\FormDraft;

// Load saved data
$formData = FormDraft::where('user_id', auth()->id())
->where('form_id', 'form2mmt8')
->where('case_id', $case_no)

->first();

$savedScores = [];

if ($formData) {
$decoded = json_decode($formData->form_data, true);
$savedScores = $decoded ?? [];
}

// Helper function to get saved value
function getSavedValue($scores, $key, $default = '') {
return $scores['scores'][$key] ?? $default;
}
?>
 


<form id="form2mmt8" class="scoring-form" data-form-id="form2mmt8">
    <div class="table-container">
        <h3>
            Case  Presentation: Initial <br>
            <hr>
            Manual Muscle Testing-8 (MMT-8)
        </h3>
        <h5 style="font-size: 15px;">
            Answers with possible correct responses based on patient's examination in the case.
        </h5>
        <table class="table table-striped table-bordered mediaTable table-1">
            <thead>
                <tr>
                     <th class="essential persist"><strong>Muscle Groups </strong></th>
                    <th class="optional" style="width: 220px; "><strong>Right <br> (0-10) <br> NA: Not Assessed</strong></th>
                    <th class="optional" style="width: 210px;"><strong>Left <br> (0-10) <br> NA: Not Assessed</strong></th>
                    <th class="optional" style="width: 210px;"><strong>Axial <br> (0-10) <br> NA: Not Assessed </strong></th>
                </tr>
            </thead>
            <tr class="section-1">
                <td colspan="5" style="border: none; background-color: transparent; text-align: center;">
                    <strong>Axial Muscle</strong>
                </td>
            </tr>
            <tbody>
                <!-- Section 1 -->
                <tr class="section-1">
                    
                    <td> <strong>Neck Flexor</strong>  </td>
                    <td></td>
                    <td></td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[neck_flexor_axial]"
                                onchange="calculateTotalsForTable(this.closest('table'))">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'neck_flexor_axial' )==$val
                                    ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[neck_flexor_axial]" value="select">
                        </div>
                    </td>
                </tr>
                <tr class="section-1">
                    <th colspan="5" class="text-center">Proximal Muscles</th>
                </tr>
                <tr class="section-1">
                   
                    <td><strong>Deltoid</strong> </td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[deltoid_right]"
                                onchange="calculateTotalsForTable(this.closest('table'))">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'deltoid_right' )==$val
                                    ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[deltoid_right]" value="select">
                        </div>
                    </td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[deltoid_left]"
                                onchange="calculateTotalsForTable(this.closest('table'))">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'deltoid_left' )==$val
                                    ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[deltoid_left]" value="select">
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1">
                     <td><strong>Biceps</strong> </td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[biceps_right]"
                                onchange="calculateTotalsForTable(this.closest('table'))">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'biceps_right' )==$val
                                    ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[biceps_right]" value="select">
                        </div>
                    </td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[biceps_left]"
                                onchange="calculateTotalsForTable(this.closest('table'))">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'biceps_left' )==$val
                                    ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[biceps_left]" value="select">
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1">
                     <td><strong>Quadriceps</strong> </td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[quadriceps_right]"
                                onchange="calculateTotalsForTable(this.closest('table'))">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'quadriceps_right' )==$val
                                    ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[quadriceps_right]" value="select">
                        </div>
                    </td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[quadriceps_left]"
                                onchange="calculateTotalsForTable(this.closest('table'))">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'quadriceps_left' )==$val
                                    ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[quadriceps_left]" value="select">
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1">
                     <td><strong>Gluteus Medius</strong> </td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[gluteus_medius_right]"
                                onchange="calculateTotalsForTable(this.closest('table'))">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'gluteus_medius_right' )==$val
                                    ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[gluteus_medius_right]" value="select">
                        </div>
                    </td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[gluteus_medius_left]"
                                onchange="calculateTotalsForTable(this.closest('table'))">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'gluteus_medius_left' )==$val
                                    ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[gluteus_medius_left]" value="select">
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1">
                     <td><strong>Gluteus Maximus </strong></td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[gluteus_maximus_right]"
                                onchange="calculateTotalsForTable(this.closest('table'))">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'gluteus_maximus_right'
                                    )==$val ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[gluteus_maximus_right]" value="select">
                        </div>
                    </td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[gluteus_maximus_left]"
                                onchange="calculateTotalsForTable(this.closest('table'))">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'gluteus_maximus_left' )==$val
                                    ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[gluteus_maximus_left]" value="select">
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1">
                    <th colspan="5" class="text-center" style="background-color: aliceblue;">Distal
                        Muscles</th>
                </tr>

                <tr class="section-1">
                     <td><strong>Wrist Extensor</strong></td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[wrist_extensor_right]"
                                onchange="calculateTotalsForTable(this.closest('table'))">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'wrist_extensor_right' )==$val
                                    ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[wrist_extensor_right]" value="select">
                        </div>
                    </td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[wrist_extensor_left]"
                                onchange="calculateTotalsForTable(this.closest('table'))">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'wrist_extensor_left' )==$val
                                    ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[wrist_extensor_left]" value="select">
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1">
                     <td><strong>Ankle Dorsiflexion</strong></td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[ankle_dorsiflexion_right]"
                                onchange="calculateTotalsForTable(this.closest('table'))">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'ankle_dorsiflexion_right'
                                    )==$val ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[ankle_dorsiflexion_right]" value="select">
                        </div>
                    </td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[ankle_dorsiflexion_left]"
                                onchange="calculateTotalsForTable(this.closest('table'))">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'ankle_dorsiflexion_left'
                                    )==$val ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[ankle_dorsiflexion_left]" value="select">
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1">
                    <th colspan="5" class="text-center" style="background-color: aliceblue;">MMT-8
                        Scoring</th>
                </tr>

                <tr class="section-1 total-scoring-value">
                     <td><strong>Total Score</strong></td>
                    <td colspan="3">
                        <input type="text" class="form-control" readonly name="scores[total_scoring_value]"
                            value="<?php echo e(getSavedValue($savedScores, 'total_scoring_value', '')); ?>">
                        <input type="hidden" name="input_types[total_scoring_value]" value="text">
                    </td>
                </tr>
                <tr class="section-1 maximum-scoring">
                     <td><strong>Total Maximum Possible Score</strong></td>
                    <td>
                        <div class="slider-container">
                            <input type="text" class="form-control" readonly name="scores[max_scoring_right]"
                                value="<?php echo e(getSavedValue($savedScores, 'max_scoring_right', '')); ?>">
                            <input type="hidden" name="input_types[max_scoring_right]" value="text">
                        </div>
                    </td>
                    <td>
                        <div class="slider-container">
                            <input type="text" class="form-control" readonly name="scores[max_scoring_left]"
                                value="<?php echo e(getSavedValue($savedScores, 'max_scoring_left', '')); ?>">
                            <input type="hidden" name="input_types[max_scoring_left]" value="text">
                        </div>
                    </td>
                    <td>
                        <div class="slider-container">
                            <input type="text" class="form-control" readonly name="scores[max_scoring_axial]"
                                value="<?php echo e(getSavedValue($savedScores, 'max_scoring_axial', '')); ?>">
                            <input type="hidden" name="input_types[max_scoring_axial]" value="text">
                        </div>
                    </td>
                </tr>
                <tr class="section-1 total-scoring-value">
                     <td><strong>Maximum score</strong></td>
                    <td colspan="3">
                        <input type="text" class="form-control" readonly name="scores[maximum_score]" 
                               value="<?php echo e(getSavedValue($savedScores, 'maximum_score', '')); ?>">
                        <input type="hidden" name="input_types[maximum_score]" value="text">
                    </td>
                </tr>
                <tr class="section-1 total-individual-score">
                     <td><strong>Maximum Individual Score</strong>

                    </td>
                    <td>
                        <div class="slider-container">
                            <input type="text" class="form-control" readonly name="scores[total_individual_right]"
                                value="<?php echo e(getSavedValue($savedScores, 'total_individual_right', '')); ?>">
                            <input type="hidden" name="input_types[total_individual_right]" value="text">
                        </div>
                    </td>
                    <td>
                        <div class="slider-container">
                            <input type="text" class="form-control" readonly name="scores[total_individual_left]"
                                value="<?php echo e(getSavedValue($savedScores, 'total_individual_left', '')); ?>">
                            <input type="hidden" name="input_types[total_individual_left]" value="text">
                        </div>
                    </td>
                    <td>
                        <div class="slider-container">
                            <input type="text" class="form-control" readonly name="scores[total_individual_axial]"
                                value="<?php echo e(getSavedValue($savedScores, 'total_individual_axial', '')); ?>">
                            <input type="hidden" name="input_types[total_individual_axial]" value="text">
                        </div>
                    </td>
                </tr>




 
            </tbody>
        </table>
        
    </div>


</form>
 <script>
    function calculateTotalsForTable(table) {
    // Initialize objects to store totals
    let columnTotals = { right: 0, left: 0, axial: 0 };
    let maxPossibleScores = { right: 0, left: 0, axial: 0 };
    let naCounts = { right: 0, left: 0, axial: 0 };

    // Get all rows except the total rows
    let rows = table.querySelectorAll("tr.section-1:not(.total-individual-score):not(.maximum-scoring):not(.total-scoring-value)");

    rows.forEach((row) => {
        // Skip section header rows
        if (row.querySelector('th')) return;

        // Get all cells in the row
        let cells = row.querySelectorAll("td");
        if (cells.length < 4) return; // Skip if not enough columns

        // Right column (index 1)
        processColumn(cells[1], 'right');
        // Left column (index 2)
        processColumn(cells[2], 'left');
        // Axial column (index 3)
        processColumn(cells[3], 'axial');

        function processColumn(cell, column) {
            let select = cell.querySelector(".option-value");
            if (select) {
                let value = select.value === "NA" ? 0 : parseFloat(select.value) || 0;
                columnTotals[column] += value;
                
                // For maximum possible, each non-NA select could contribute up to 10
                if (select.value === "NA") {
                    naCounts[column]++;
                } else {
                    maxPossibleScores[column] += 10;
                }
            }
        }
    });

    // Update Total Individual Score row
    let totalIndividualInputs = table.querySelectorAll("tr.total-individual-score td .form-control");
    if (totalIndividualInputs.length >= 3) {
        totalIndividualInputs[0].value = columnTotals.right;
        totalIndividualInputs[1].value = columnTotals.left;
        totalIndividualInputs[2].value = columnTotals.axial;
    }

    // Update Maximum Possible Score row
    let maxScoringInputs = table.querySelectorAll("tr.maximum-scoring td .form-control");
    if (maxScoringInputs.length >= 3) {
        maxScoringInputs[0].value = maxPossibleScores.right;
        maxScoringInputs[1].value = maxPossibleScores.left;
        maxScoringInputs[2].value = maxPossibleScores.axial;
    }

    // Calculate and update Maximum score (sum of all max possible scores)
    let maximumScore = maxPossibleScores.right + maxPossibleScores.left + maxPossibleScores.axial;
    let maximumScoreInput = table.querySelector("tr.total-scoring-value input[name='scores[maximum_score]']");
    if (maximumScoreInput) {
        maximumScoreInput.value = maximumScore;
    }

    // Calculate and update Total Score (sum of all individual scores)
    let totalScore = columnTotals.right + columnTotals.left + columnTotals.axial;
    let totalScoreInput = table.querySelector("tr.total-scoring-value input[name='scores[total_scoring_value]']");
    if (totalScoreInput) {
        totalScoreInput.value = totalScore;
    }
}
 </script><?php /**PATH E:\Case Management Software\21Aprilupdated\resources\views/doctors/forms/form2mmt8.blade.php ENDPATH**/ ?>