<?php
$formData = $savedScores['form1Mdaat']['scores'] ?? [];
?>

<div class="panel panel-default" id="form1Mdaat">
    <div class="panel-heading"><strong>Form MDAAT (Readonly)</strong></div>
    <div class="panel-body">
        <div class="table-container">
            <h3>Case Presentation: Initial
                <br>
                <hr>
                Myositis Disease Activity Assessment Tool (MDAAT)
            </h3>
            <h5 style="font-size:15px;">
                Readonly version of the submitted form
            </h5>
            <table class="table table-striped table-bordered mediaTable table-1">
                <thead>
                    <tr>
                        <th class="optional fixed-id">S/N</th>
                        <th class="essential persist">Disease Activity</th>
                        <th class="optional" style="width: 150px;">Overall Organ Disease Activity (0-10 cm) VAS</th>
                        <th class="optional" style="width: 200px;">Clinical Features (0,1,2,3,4, NA: Not Assessed)</th>
                    </tr>
                </thead>
                <tbody>
                    <tr >
                        <td class="fixed-id"></td>
                        <td>Constitutional Disease Activity</td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['disease_activity_1'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <td class="fixed-id">1</td>
                        <td>Pyrexia</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['clinical_features_1_1'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">2</td>
                        <td>Weight Loss</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['clinical_features_1_2'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">3</td>
                        <td>Fatigue</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['clinical_features_1_3'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr >
                        <td class="fixed-id"></td>
                        <td>Cutaneous Disease Activity</td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['disease_activity_2'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <td class="fixed-id">4</td>
                        <td>Cutaneous Ulceration</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['clinical_features_2_1'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">5</td>
                        <td>Erythroderma</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['clinical_features_2_2'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">6</td>
                        <td>Panniculitis</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['clinical_features_2_3'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id"><strong>7</strong></td>
                        <td><strong>Erythematous Rash</strong></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">
                            A. with secondary changes (e.g. accompanied by erosions, vesiculobullous change or necrosis)
                        </td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['erythematous_rash_a'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. without secondary changes</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['erythematous_rash_b'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">8</td>
                        <td>Heliotrope rash</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['clinical_features_2_5'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">9</td>
                        <td>Gottron's papules/sign</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['clinical_features_2_6'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">10</td>
                        <td>Periungual capillary changes</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['clinical_features_2_7'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">11</td>
                        <td>Alopecia</td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">A. Diffuse hair Loss</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['alopecia_a'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. Focal, Patchy with Erythema</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['alopecia_b'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">12</td>
                        <td>Mechanics Hand</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['mechanics_hand'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr >
                        <td class="fixed-id"></td>
                        <td>Skeletal Disease Activity</td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['disease_activity_3'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <td class="fixed-id"><strong>13</strong></td>
                        <td><strong>Arthritis</strong></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">A. Severe active polyarthritis</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['polyarthritis_a'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. Moderately active arthritis</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['moderately_active_arthritis_b'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">C. Mild arthritis</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['milarth_c'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">14</td>
                        <td>Arthralgia</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['arthralgia'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr >
                        <td class="fixed-id"></td>
                        <td>GI Disease Activity</td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['disease_activity_4'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <td class="fixed-id"><strong>15</strong></td>
                        <td><strong>Dysphagia</strong></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">A. Moderate/severe dysphagia</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['dysphagia_a'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. Mild dysphagia</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['dysphagia_b'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id"><strong>16</strong></td>
                        <td><strong>Abdominal Pain</strong></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">A. Severe</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['abdominal_pain_a'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. Moderate</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['abdominal_pain_b'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">C. Mild</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['abdominal_pain_c'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr >
                        <td class="fixed-id"></td>
                        <td>Pulmonary Disease Activity</td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['disease_activity_5'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <td class="fixed-id"><strong>17</strong></td>
                        <td><strong>Resp. Muscle weakness without ILD</strong></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">A. Dyspnea at rest</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['resp_muscle_weakness_a'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. Dyspnea on exertion</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['resp_muscle_weakness_b'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id"><strong>18</strong></td>
                        <td><strong>Active Reversible ILD</strong></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">A. Dyspnea or cough due to ILD</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['active_ild_a'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. Parenchymal abnormalities on chest x-ray or high-resolution CT scan (HRCT) and/or ground glass shadowing on HRCT</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['active_ild_b'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">C. Pulmonary Function Tests: ≥ 10% change in FVC OR ≥ 15% change in DLCO</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['active_ild_c'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id"><strong>19</strong></td>
                        <td><strong>Dysphonia</strong></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">A. Moderate to severe</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['dysphonia_a'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. Mild</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['dysphonia_b'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr >
                        <td class="fixed-id"></td>
                        <td>Cardiovascular Disease Activity</td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['cardiovascular_disease_activity'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <td class="fixed-id">20</td>
                        <td>Pericarditis</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['clinical_features_6_1'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">21</td>
                        <td>Myocarditis</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['clinical_features_6_2'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id"><strong>22</strong></td>
                        <td><strong>Arrhythmias</strong></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">A. Severe arrhythmia</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['arrhythmia_a'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. Other arrhythmia, except sinus tachycardia</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['arrhythmia_b'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">23</td>
                        <td>Sinus Tachycardia</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['sinus_tachycardia'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr >
                        <td class="fixed-id"></td>
                        <td>
                            Other Disease Activity<br>
                            <input type="text" class="form-control form-control-sm w-25" value="<?php echo e($formData['other_disease_activity_note'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['other_disease_activity_slider'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['other_disease_activity_radio'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr >
                        <td class="fixed-id"></td>
                        <td>Extra Muscular Global Assessment</td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['extra_muscular_global_assessment'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td></td>
                    </tr>

                    <tr >
                        <td class="fixed-id"></td>
                        <td>Muscle Disease Activity</td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['muscle_disease_activity'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <td class="fixed-id"><strong>24</strong></td>
                        <td><strong>Myositis</strong></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">A. Severe muscle inflammation</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['myositis_a'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. Moderate muscle inflammation</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['myositis_b'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">C. Mild muscle inflammation</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['myositis_c'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">25</td>
                        <td>Myalgia</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['myalgia'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id"></td>
                        <td>Global Disease Activity</td>
                        <td>
                            <input type="text" class="form-control" value="<?php echo e($formData['global_disease_activity'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div><?php /**PATH /home/yxq9qmneoal1/public_html/novartistraining.gurukoolhub.com/resources/views/admin/forms/form1MdaatReadonly.blade.php ENDPATH**/ ?>