

<?php $__env->startSection('content'); ?>
<br><br><br>

<div class="container">
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade in text-center">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            <strong><i class="glyphicon glyphicon-ok-circle"></i> Success! </strong> <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <h2 class="text-primary text-center"><i class="glyphicon glyphicon-user"></i> User Management</h2>

    <div class="panel panel-default shadow-box">
        <div class="panel-heading">
            <h4 class="panel-title"><i class="glyphicon glyphicon-th-list"></i> All Users</h4>
        </div>
        <div class="panel-body">
            <table class="table table-bordered custom-table">
                <thead>
                    <tr class="table-header">
                        <th>#</th>
                        <th>Username</th>
                        <th>Email</th>
                        <th>Registered On </th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($key + 1); ?></td>
                            <td><?php echo e($user->username); ?></td>
                            <td><?php echo e($user->email); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($user->created_at)->setTimezone('America/New_York')->format('m/d/Y h:i A')); ?></td> 
                            <td>
                                <?php if($user->is_active): ?>
                                    <span class="label label-success">Active</span>
                                <?php else: ?>
                                    <span class="label label-danger">Inactive</span>
                                <?php endif; ?>
                            </td>
                            <td class="text-center">
                                <form action="<?php echo e(route('users.toggleStatus', $user->id)); ?>" method="POST" style="display:inline;">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-sm <?php echo e($user->is_active ? 'btn-warning' : 'btn-success'); ?>">
                                        <i class="glyphicon glyphicon-refresh"></i> <?php echo e($user->is_active ? 'Deactivate' : 'Activate'); ?>

                                    </button>
                                </form>
                                <button class="btn btn-danger btn-sm delete-btn" data-id="<?php echo e($user->id); ?>">
                                    <i class="glyphicon glyphicon-trash"></i>
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <?php echo e($users->links()); ?>

        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header bg-danger">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="glyphicon glyphicon-exclamation-sign"></i> Confirm Deletion</h4>
            </div>
            <div class="modal-body text-center">
                Are you sure you want to delete this user?
            </div>
            <div class="modal-footer">
                <form id="deleteForm" method="POST">
                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">Delete</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    $('.delete-btn').click(function() {
        var userId = $(this).data('id');
        $('#deleteForm').attr('action', '/users/' + userId);
        $('#deleteModal').modal('show');
    });
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yxq9qmneoal1/public_html/novartistraining.gurukoolhub.com/resources/views/users/index.blade.php ENDPATH**/ ?>