<?php
use App\Models\FormDraft;

$formData = FormDraft::where('user_id', auth()->id())
->where('form_id', 'form11')
->where('case_id', $case_no)

->first();

$savedScores = [];

if ($formData) {
$decoded = json_decode($formData->form_data, true);
$savedScores = $decoded ?? [];
}
?>

<form id="form11" class="scoring-form" data-form-id="form11">
<input type="hidden" name="scores[total_activity_score]" id="total-followup-activity-score-hidden">
<input type="hidden" name="scores[total_damage_score]" id="total-followup-damage-score-hidden">

    <div class="table-container1">
        <table class="table table-striped table-bordered mediaTable table-2">
            <thead>
                <tr class="section-2-sub">
                    <th colspan="5"
                        style="border: 1px solid black; padding: 15px; text-align: center; font-size: 16px; color: #000;">
                       <strong> Gottron's - Hands (Second Section)</strong>
                    </th>
                </tr>
                <tr>
                    <th colspan="2"
                        style="border: 1px solid black; padding: 12px; text-align: left; font-size: 14px; color: #000;">
                        Examine the patient's hands and double score if papules are present
                    </th>
                    <th style="background-color: #4a4a4a; width: 15px; border: 1px solid black;"></th>
                    <th colspan="2"
                        style="border: 1px solid black; padding: 12px; text-align: left; font-size: 14px; color: #000;">
                        Examine patient's hands and score if damage is present
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr style="background:linear-gradient(90deg, #82c9e6, #a09ebd)">
                    <td class="alltext"
                        style="border: 1px solid black; padding: 12px; font-weight: bold; color: #000; font-size: 14px;">
                        0 - absent <br> 1 - pink; faint erythema <br> 2 - red erythema <br> 3 - dark red
                    </td>
                    <td style="border: 1px solid black; padding: 12px; text-align: center;">
                        <div class="radio-container-vertical" style="display: flex; flex-direction: column; gap: 8px;">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label
                                style="display: flex; align-items: center; justify-content: center; font-size: 14px;">
                                <input type="radio" name="scores[erythema_2]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['erythema_2']) && $savedScores['scores']['erythema_2'] == $val ? 'checked' : ''); ?>

                                    onchange="calculateFinalScore2()" style="margin-right: 5px;">
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[erythema_2]" value="radio">
                        </div>
                        <div style="margin-top:10px;">
                            <label>Doubled Score (Read Only):</label>
                            <input type="text" id="erythema_final_score_2" class="form-control" readonly value="<?php echo e(isset($savedScores['scores']['erythema_2']) ? (
               (isset($savedScores['scores']['papule_present_2']) && $savedScores['scores']['papule_present_2'] == 'yes') 
               ? $savedScores['scores']['erythema_2'] * 2 
               : $savedScores['scores']['erythema_2']) : ''); ?>">
                        </div>

                    </td>
                    <td style="background-color: #4a4a4a; width: 15px;"></td>
                    <td class="alltext"
                        style="border: 1px solid black; padding: 12px; font-weight: bold; color: #000; font-size: 14px;">
                        0 - absent <br> 1 - dyspigmentation <br> 2 - scarring
                    </td>
                    <td style="border: 1px solid black; padding: 12px; text-align: center;">
                        <div class="radio-container-vertical" style="display: flex; flex-direction: column; gap: 8px;">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label
                                style="display: flex; align-items: center; justify-content: center; font-size: 14px;">
                                <input type="radio" name="scores[damage_2]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['damage_2']) && $savedScores['scores']['damage_2'] == $val ? 'checked' : ''); ?>

                                    style="margin-right: 5px;">
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[damage_2]" value="radio">
                        </div>
                    </td>
                </tr>

                
                <tr style="text-align: center; background:linear-gradient(90deg, #82c9e6, #a09ebd)">
                    <td class="alltext"
                        style="border: 1px solid black; padding: 12px; text-align: left; font-size: 14px;">
                        Papule Present <br> 1 - Present 0 - Absent
                    </td>
                    <td style="border: 1px solid black; padding: 12px; text-align: center;">
                        <div class="radio-container-vertical" style="display: flex; flex-direction: column; gap: 8px;">
                            <label
                                style="display: flex; align-items: center; justify-content: center; font-size: 14px;">
                                <input type="radio" name="scores[papule_present_2]" value="yes"
                                    <?php echo e(isset($savedScores['scores']['papule_present_2']) && $savedScores['scores']['papule_present_2'] == 'yes' ? 'checked' : ''); ?>

                                    onchange="calculateFinalScore2()" style="margin-right: 5px;">
                                Yes
                            </label>
                            <label
                                style="display: flex; align-items: center; justify-content: center; font-size: 14px;">
                                <input type="radio" name="scores[papule_present_2]" value="no"
                                    <?php echo e(isset($savedScores['scores']['papule_present_2']) && $savedScores['scores']['papule_present_2'] == 'no' ? 'checked' : ''); ?>

                                    onchange="calculateFinalScore2()" style="margin-right: 5px;">
                                No
                            </label>
                        </div>
                        <input type="hidden" name="input_types[papule_present_2]" value="radio">
                    </td>
                    <td style="background-color: #4a4a4a;" colspan="3"></td>
                </tr>

                
                <input type="hidden" name="final_erythema_score_2" id="final-erythema-score-2">
            </tbody>
        </table>
    </div>



    
    <br>
    <hr>
    <hr>
    <div class="table-container1">
        <table class="table table-striped table-bordered mediaTable table-2" >
            <thead>
                <tr class="section-2-sub">
                    <th colspan="2"
                        style="border: 1px solid black; padding: 15px; text-align: center; font-size: 18px; color: #000;">
                       <strong> Periungual</strong>
                    </th>
                </tr>
                <tr style="background:linear-gradient(90deg, #82c9e6, #a09ebd)">
                    <th colspan="2" style="border: 1px solid black; padding: 12px; text-align: left; color: #000;">
                        Periungual changes (examine)
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr style="background:linear-gradient(90deg, #82c9e6, #a09ebd)">
                    <td class="alltext" style="border: 1px solid black; padding: 12px;">
                        0 - absent <br> 1 - pink/red erythema / microscopic telangiectasias <br> 2 - visible
                        telangiectasias
                    </td>
                    <td style="border: 1px solid black; padding: 12px;">
                        <div class="radio-container-vertical">
                            <?php $__currentLoopData = [0, 1, 2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[periunguals]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['periunguals']) && $savedScores['scores']['periunguals'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[periunguals]" value="radio">
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    
    <br>
    <hr>
    <div class="table-container1">
        <table class="table table-striped table-bordered mediaTable table-2">
            <thead>
                <tr class="section-2-sub">
                    <th colspan="3"
                        style="border: 1px solid black; padding: 15px; text-align: center; font-size: 18px; color: #000;">
                        <strong>Alopecia</strong>
                    </th>
                </tr>
                <tr style="background:linear-gradient(90deg, #82c9e6, #a09ebd)">
                    <th colspan="2" style="border: 1px solid black; padding: 12px; text-align: left; color: #000;">
                        Recent Hair loss (within last 30 days as reported by the patient)
                    </th>
                    <th style="background-color: #4a4a4a; width: 15px; border: 1px solid black;"></th>
                </tr>
            </thead>
            <tbody>
                <tr style="background:linear-gradient(90deg, #82c9e6, #a09ebd)">
                    <td class="alltext" style="border: 1px solid black; padding: 12px;">
                        0 - absent <br> 1 - present
                    </td>
                    <td style="border: 1px solid black; padding: 12px;">
                        <div class="radio-container-vertical">
                            <?php $__currentLoopData = [0, 1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[alopecias]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['alopecias']) && $savedScores['scores']['alopecias'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[alopecias]" value="radio">
                        </div>
                    </td>
                    <td style="background-color: #4a4a4a; width: 15px; border: 1px solid black;"></td>
                </tr>
            </tbody>
        </table>
    </div>

    
<br><br>
<div class="table-container">
    <table class="table table-bordered">
        <thead>
            <tr>
                <th colspan="2"
                    style="text-align: center; font-size: 24px; background: linear-gradient(135deg, #317c81, #a31660, #ff5f6d); color: white; border-radius: 8px;">
                    🔍 <strong>Overall Score Summary</strong>
                </th>
            </tr>
        </thead>
        <tbody>
            
            <tr>
                <td style="background-color: #f0f9ff; border: 2px solid #007bff; font-size: 16px; padding: 15px;">
                    <div style="font-weight: bold; color: #003366; margin-bottom: 8px;">
                         <span
                            style="background: linear-gradient(to right, #00c6ff, #0072ff); color: white; padding: 6px 14px; border-radius: 25px;">
                            Total Activity Score
                        </span>
                    </div>
                    <div style="font-size: 14px; color: #333;">
                        (Add scores from Erythema, Scale, Excoriation, Ulceration, Gottron’s, Periungual, Alopecia)
                    </div>
                </td>
                <td id="total-followup-activity-score"
                    style="background-color: #d6f0ff; border: 2px solid #007bff; text-align: center; font-size: 30px; font-weight: bold; color: #003366;">
                    0
                </td>
            </tr>

            
            <tr>
                <td style="background-color: #fff0f0; border: 2px solid #dc3545; font-size: 16px; padding: 15px;">
                    <div style="font-weight: bold; color: #660000; margin-bottom: 8px;">
                         <span
                            style="background: linear-gradient(to right, #ff6a6a, #dc3545); color: white; padding: 6px 14px; border-radius: 25px;">
                            Total Damage Score
                        </span>
                    </div>
                    <div style="font-size: 14px; color: #333;">
                        (Add scores from Poikiloderma, Calcinosis)
                    </div>
                </td>
                <td id="total-followup-damage-score"
                    style="background-color: #ffe6e6; border: 2px solid #dc3545; text-align: center; font-size: 30px; font-weight: bold; color: #660000;">
                    0
                </td>
            </tr>
        </tbody>
    </table>
</div>



    <br>
    <hr>
    
</form>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        function calculateForm11TotalActivity() {
            let totalScore = 0;
    
            // Erythema + Papule logic
            const erythema = document.querySelector('input[name="scores[erythema_2]"]:checked');
            const papule = document.querySelector('input[name="scores[papule_present_2]"]:checked');
            let erythemaFinal = 0;
    
            if (erythema) {
                const val = parseInt(erythema.value);
                erythemaFinal = (papule && papule.value === 'yes') ? val * 2 : val;
                totalScore += erythemaFinal;
    
                const displayInput = document.getElementById("erythema_final_score_2");
                if (displayInput) displayInput.value = erythemaFinal;
    
                const hiddenInput = document.getElementById("final-erythema-score-2");
                if (hiddenInput) hiddenInput.value = erythemaFinal;
            }
    
            // Periungual
            const periungual = document.querySelector('input[name="scores[periunguals]"]:checked');
            if (periungual) totalScore += parseInt(periungual.value);
    
            // Alopecia
            const alopecias = document.querySelector('input[name="scores[alopecias]"]:checked');
            if (alopecias) totalScore += parseInt(alopecias.value);
    
            // Damage
            const damage = document.querySelector('input[name="scores[damage_2]"]:checked');
            if (damage) totalScore += parseInt(damage.value);
    
            // Display result
            document.getElementById("total-followup-activity-score").textContent = totalScore;
            document.getElementById("total-followup-activity-score-hidden").value = totalScore;
        }
    
        function calculateForm11Damage() {
            let totalDamage = 0;
    
            const damage = document.querySelector('input[name="scores[damage_2]"]:checked');
            if (damage) totalDamage += parseInt(damage.value);
    
            document.getElementById("total-followup-damage-score").textContent = totalDamage;
            document.getElementById("total-followup-damage-score-hidden").value = totalDamage;
        }
    
        function attachForm11Listeners() {
            const selectors = [
                'input[name="scores[erythema_2]"]',
                'input[name="scores[papule_present_2]"]',
                'input[name="scores[periunguals]"]',
                'input[name="scores[alopecias]"]',
                'input[name="scores[damage_2]"]',
            ];
    
            selectors.forEach(selector => {
                document.querySelectorAll(selector).forEach(input => {
                    input.addEventListener('change', () => {
                        calculateForm11TotalActivity();
                        calculateForm11Damage();
                    });
                });
            });
        }
    
        // INIT
        attachForm11Listeners();
        calculateForm11TotalActivity();
        calculateForm11Damage();
    });
    </script>
    <?php /**PATH E:\Case Management Software\21Aprilupdated\resources\views/doctors/forms/form11.blade.php ENDPATH**/ ?>