 
 <?php $__env->startSection('content'); ?>
     <style>
         * {
             font-family: 'Poppins', sans-serif;
             box-sizing: border-box;
         }

         html,
         body {
             margin: 0;
             padding: 0;
             overflow-x: hidden !important;
             overflow-y: hidden;
             width: 100%;
             height: 100%;
             background: linear-gradient(135deg, #317c81, #a31660, #ff5f6d);
         }

         body {
             position: relative;
         }

         /* Scroll Prevention */
         .main-container,
         .content-wrapper,
         .document-container,
         .scrollable-section,
         .scrollable {
             overflow-x: hidden !important;
         }

         /* Layout Containers */
         .main-container {
             display: flex;
             flex-direction: column;
             gap: 15px;
             padding: 15px;
             height: 100vh;
             width: 100% !important;
         }

         .content-wrapper {
             display: flex;
             gap: 15px;
             flex-grow: 1;
             overflow-y: auto;
             height: calc(100vh - 100px);
             width: 100% !important;
             margin-top: 0 !important;
             padding-top: 0 !important;
         }

         /* Panels */
         .document-container,
         .scrollable-section {
             background: #ffffff;
             padding: 12px;
             border-radius: 10px;
             box-shadow: 0px 4px 15px rgba(0, 0, 0, 0.2);
             flex: 1;
             height: 100%;
             position: relative;
             transition: all 0.3s ease-in-out;
         }

         /* Sticky Headers */
         .document-container .header-bar,
         .scrollable-section .header-bar {
             position: sticky;
             top: 0;
             background: linear-gradient(135deg, #1B1F24, #2A4B7C);
             z-index: 10;
             padding: 10px 15px;
             display: flex;
             justify-content: space-between;
             align-items: center;
             border-radius: 8px 8px 0 0;
             width: 100% !important;
         }

         /* Title */
         .header-bar h4 {
             margin: 0;
             font-weight: 600;
             font-size: 18px;
             color: white;
         }

         /* Inner Scroll */
         .scrollable {
             overflow-y: auto;
             height: calc(100% - 50px);
             width: 100% !important;
         }

         /* Fullscreen Mode */
         .fullscreen {
             position: fixed !important;
             top: 0;
             left: 0;
             width: 100% !important;
             height: 100% !important;
             z-index: 10000;
             background: #ffffff;
             box-shadow: 0px 6px 20px rgba(0, 0, 0, 0.3);
         }

         /* Word Content & iFrames Fix */
         .word-content,
         .scrollable iframe {
             max-width: 100% !important;
             overflow-x: auto;
             display: block;
         }

         /* Horizontal List */
         .horizontal-list {
             list-style-type: none;
             padding: 0;
             display: flex;
             flex-wrap: wrap;
             width: 100%;
         }

         .horizontal-list li {
             margin-right: 20px;
             font-size: 14px;
         }

         /* Input Errors */
         input.input-error,
         select.input-error,
         .radio-container.input-error {
             border: 2px solid #dc3545 !important;
             background-color: #ffe6e6 !important;
             border-radius: 5px !important;
         }

         /* Red Border */
         .input-error {
             border: 2px solid red !important;
             box-shadow: 0 0 5px red !important;
         }

         /* Toast Notification */
         #custom-alert {
             position: fixed;
             top: 80px;
             right: 30px;
             background-color: #dc3545;
             color: white;
             padding: 15px 20px;
             border-radius: 8px;
             box-shadow: 0 4px 10px rgba(0, 0, 0, 0.3);
             z-index: 9999;
             display: none;
             font-size: 16px;
             animation: slideIn 0.3s ease-in-out;
         }

         @keyframes slideIn {
             from {
                 opacity: 0;
                 right: 0;
             }

             to {
                 opacity: 1;
                 right: 30px;
             }
         }

         input[type="radio"].custom-highlight {
             position: relative;
             width: 16px;
             height: 16px;
             margin: 0 4px;
         }

         /* Draw green dot inside disabled + checked radio */
         input[type="radio"].custom-highlight:checked:disabled::before {
             content: '';
             position: absolute;
             top: 3px;
             left: 3px;
             width: 8px;
             height: 8px;
             background-color: #4CAF50;
             /* Change color as needed */
             border-radius: 50%;
             z-index: 2;
         }

         input[type=range].is-invalid,
         input[type=range].input-error {
             border: 2px solid #dc3545 !important;
             box-shadow: 0 0 8px rgba(220, 53, 69, 0.6) !important;
             border-radius: 10px;
             outline: none;
         }
     </style>

     <div class="main-container" style="margin-top: 50px !important; ">
         <div class="content-wrapper">
             <div class="document-container" id="docViewer">
                 <div class="header-bar">
                     <h4><i class="fa fa-file-alt"></i> <?php echo e($document->title); ?></h4>
                     <div>
                         <a href="<?php echo e(route('user.downloadDocument', $document->id)); ?>" class="btn btn-success btn-custom">
                             <i class="fa fa-download"></i> Download
                         </a>
                         <button class="btn btn-primary btn-custom expand-btn" data-target="docViewer">
                             <i class="fa fa-expand"></i> Expand
                         </button>
                         <button class="btn btn-danger btn-custom minimize-btn" data-target="docViewer"
                             style="display: none;">
                             <i class="fa fa-compress"></i> Minimize
                         </button>
                     </div>
                 </div>
                 <div class="scrollable" id="docViewerScroll">
                     <?php if(isset($htmlContent)): ?>
                         <div class="word-content"><?php echo $htmlContent; ?></div>
                     <?php elseif(isset($document->file_path)): ?>
                         <iframe src="<?php echo e(asset('storage/' . $document->file_path)); ?>" width="100%"
                             height="600px"></iframe>
                     <?php else: ?>
                         <p class="alert alert-warning">No content available.</p>
                     <?php endif; ?>
                 </div>
             </div>


             <!-- Inside the scrollable-section div -->
             <div class="scrollable-section" id="caseScoringSheet">
                 <div class="header-bar" style="background: linear-gradient(135deg, #1B1F24, #2A4B7C)">
                     <h4><i class="fa fa-bars"></i> Myositis Case Scoring Sheet</h4>
                     <?php if(!$isSubmitted): ?>
                         <button id="save-all-drafts-btn" class="btn btn-success btn-custom">
                             <i class="fa fa-save"></i> Save Draft
                         </button>
                         <span id="save-all-success-msg"
                             style="margin-left: 15px; font-weight: bold; display: none; color:white;">
                             ✔ Saved
                         </span>
                     <?php endif; ?>
                     <div>
                         <button class="btn btn-primary btn-custom expand-btn" data-target="caseScoringSheet">
                             <i class="fa fa-expand"></i> Expand
                         </button>
                         <button class="btn btn-danger btn-custom minimize-btn" data-target="caseScoringSheet"
                             style="display: none;">
                             <i class="fa fa-compress"></i> Minimize
                         </button>
                     </div>
                 </div>
                 <div class="scrollable" id="caseScoringSheetScroll">
                     <div class="row">
                         <div class="col-sm-12 col-lg-12">
                             <!-- Existing header inputs -->
                             <?php echo $__env->make('doctors.forms.form2mmt8', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                             <?php echo $__env->make('doctors.forms.form3CDASI', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                             <?php echo $__env->make('doctors.forms.form4CDASIDamange', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                             <?php echo $__env->make('doctors.forms.form5', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                             <?php echo $__env->make('doctors.forms.form1Mdaat', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                             <?php echo $__env->make('doctors.forms.form6PGDA', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                             <br>
                             <?php echo $__env->make('doctors.forms.followUpBanner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                             <hr style="border:3px solid #1B3A57; color:#1B3A57">
                             <?php echo $__env->make('doctors.forms.form8FollowUpMMT8', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                             <?php echo $__env->make('doctors.forms.form9CDASIActivity', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                             <?php echo $__env->make('doctors.forms.form10CDASIDamage', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                             <?php echo $__env->make('doctors.forms.form11', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                             <?php echo $__env->make('doctors.forms.form7MdaatFollowUp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                             <?php echo $__env->make('doctors.forms.form12PGDA', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                             <?php if($isSubmitted): ?>
                                 <button class="btn btn-secondary" disabled><i class="fa fa-check"></i>
                                     Submitted</button>
                             <?php else: ?>
                                 <button id="submit-all-btn" class="btn btn-primary">Submit Form</button>
                             <?php endif; ?>
                             <br><br>
                         </div>
                     </div>
                 </div>
             </div>

             <!-- JavaScript -->
             
             <script>
                 $(document).ready(function() {
                     // Save All Drafts
                     $('#save-all-drafts-btn').click(function() {
                         let caseId = $('input[name="case_no"]').val();
                         if (!caseId) {
                             showCustomAlert("❌ Case ID is missing.");
                             return;
                         }

                         let formIds = [
                             'form1mdaat', 'form2mmt8', 'form3cdasi', 'form4cdasidamange',
                             'form5', 'form6pgda', 'form7mdaatfollowup', 'form8followupmmt8',
                             'form9cdasiactivity', 'form10cdasidamage', 'form11', 'form12pgda'
                         ];

                         let totalSaved = 0;

                         formIds.forEach(function(formId) {
                             let form = $('#' + formId);
                             if (form.length === 0) return;

                             let formData = form.serializeArray();

                             $.ajax({
                                 url: '<?php echo e(route('save.form.data')); ?>',
                                 method: 'POST',
                                 data: {
                                     _token: '<?php echo e(csrf_token()); ?>',
                                     form_id: formId,
                                     case_id: caseId,
                                     form_data: formData
                                 },
                                 success: function() {
                                     totalSaved++;
                                     if (totalSaved === formIds.length) {
                                         $('#save-all-success-msg').fadeIn().delay(3000)
                                             .fadeOut();
                                     }
                                 },
                                 error: function(xhr) {
                                     showCustomAlert('Save failed for ' + formId + ': ' + (xhr
                                         .responseJSON?.message ?? 'Server error.'));
                                 }
                             });
                         });
                     });

                     // Final Submit Button
                     $('#submit-all-btn').click(function() {
                         let caseId = $('input[name="case_no"]').val();
                         if (!caseId) return;

                         let isValid = true;
                         let firstInvalidElement = null;

                         // Reset previous errors
                         $('input, select, .radio-container, .radio-container-vertical').removeClass('input-error');
                         $('.text-danger').hide(); // hide previous error messages

                         // ✅ RADIO VALIDATION
                         let radioNames = {};
                         $('form input[type="radio"]').each(function() {
                             radioNames[$(this).attr('name')] = false;
                         });
                         $('form input[type="radio"]:checked').each(function() {
                             radioNames[$(this).attr('name')] = true;
                         });
                         $.each(radioNames, function(name, isChecked) {
                             if (!isChecked) {
                                 isValid = false;
                                 let container = $(`input[name="${name}"]`).closest(
                                     '.radio-container, .radio-container-vertical');
                                 container.addClass('input-error');
                                 if (!firstInvalidElement) firstInvalidElement = container;
                             }
                         });

                         // ✅ CUSTOM SLIDER VALIDATION (form6pgda + form12pgda)
                         [{
                                 id: 'activitySlider',
                                 errorId: 'sliderError'
                             },
                             {
                                 id: 'scaleSlider2',
                                 errorId: 'sliderError2'
                             }
                         ].forEach(function(sliderInfo) {
                             const slider = document.getElementById(sliderInfo.id);
                             if (slider && slider.dataset.userSelected !== 'true') {
                                 isValid = false;
                                 $(slider).addClass('input-error');
                                 $('#' + sliderInfo.errorId).show();
                                 if (!firstInvalidElement) firstInvalidElement = $(slider);
                             }
                         });

                         // ✅ TEXT / RANGE / SELECT VALIDATION
                         $('form input[type="range"], form input[type="text"]:not([readonly]), form select').each(
                             function() {
                                 let input = $(this);

                                 // Skip sliders already validated above
                                 if (input.attr('id') === 'activitySlider' || input.attr('id') ===
                                     'scaleSlider2') {
                                     return;
                                 }

                                 // Validate select dropdowns
                                 if (input.is('select')) {
                                     if (!input.val() || input.val() === '') {
                                         isValid = false;
                                         input.addClass('input-error');
                                         input.closest('.select-container').addClass('input-error');
                                         if (!firstInvalidElement) firstInvalidElement = input;
                                     }
                                 }
                                 // Validate text/range
                                 else if (!input.val()) {
                                     isValid = false;
                                     input.addClass('input-error');
                                     if (!firstInvalidElement) firstInvalidElement = input;
                                 }
                             });
                         // Validate all sliders inside form1mdaat
                         $('#form1mdaat input[type="range"]').each(function() {
                             const slider = this;
                             const userSelected = slider.dataset.userSelected;
                             const errorId = 'error_' + slider.id;

                             if (userSelected !== 'true') {
                                 isValid = false;
                                 $(slider).addClass('input-error');
                                 $('#' + errorId).show();
                                 if (!firstInvalidElement) firstInvalidElement = $(slider);
                             }
                         });
                         $('#form7mdaatfollowup input[type="range"]').each(function() {
                             const slider = $(this)[0];
                             const userSelected = slider.dataset.userSelected;
                             const errorId = 'error_' + slider.id;

                             if (userSelected !== 'true') {
                                 isValid = false;
                                 $(slider).addClass('input-error');
                                 $('#' + errorId).show();
                                 if (!firstInvalidElement) firstInvalidElement = $(slider);
                             }
                         });




                         // ✅ SCROLL TO FIRST INVALID INPUT
                         if (!isValid && firstInvalidElement && firstInvalidElement.length) {
                             const scrollContainer = $('#caseScoringSheetScroll');
                             const containerTop = scrollContainer.offset().top;
                             const elementTop = firstInvalidElement.offset().top;
                             const scrollTo = elementTop - containerTop + scrollContainer.scrollTop() - 60;

                             scrollContainer.animate({
                                 scrollTop: scrollTo
                             }, 800);
                             return;
                         }

                         // ✅ CONFIRMATION & AJAX SUBMIT
                         if (confirm(
                                 "⚠️ Are you sure you want to submit the final form? You will not be able to edit after submission."
                             )) {
                             $.ajax({
                                 url: '<?php echo e(route('submit.all.forms')); ?>',
                                 method: 'POST',
                                 data: {
                                     _token: '<?php echo e(csrf_token()); ?>',
                                     case_id: caseId
                                 },
                                 success: function() {
                                     $('#save-all-drafts-btn').remove();
                                     $('#submit-all-btn')
                                         .html('<i class="fa fa-check"></i> Submitted')
                                         .removeClass('btn-primary')
                                         .addClass('btn-secondary')
                                         .prop('disabled', true);

                                     $('input, select, textarea').prop('disabled', true);
                                     showCustomAlert('✅ Form submitted successfully.');
                                 },
                                 error: function(xhr) {
                                     alert(xhr.responseJSON?.message || '❌ Submission failed.');
                                 }
                             });
                         }
                     });


                     // Disable inputs if submitted
                     const isSubmitted = <?php echo json_encode($isSubmitted, 15, 512) ?>;
                     if (isSubmitted) {
                         $('input, select, textarea').prop('disabled', true);
                     }

                     // Custom alert helper
                     function showCustomAlert(message) {
                         let alertBox = $('#custom-alert');
                         if (!alertBox.length) {
                             $('body').append(
                                 '<div id="custom-alert" style="display:none; position:fixed; top:20px; left:50%; transform:translateX(-50%); padding:15px 25px; z-index:9999; font-weight:bold; color:white; border-radius:8px;"></div>'
                             );
                             alertBox = $('#custom-alert');
                         }

                         alertBox.text(message);
                         alertBox.css('background-color', '#28a745');
                         alertBox.fadeIn().delay(4000).fadeOut();
                     }

                     // 🔻 Add this at the end of the ready block:
                     document.querySelectorAll('input[type="range"]').forEach(slider => {
                         slider.addEventListener('input', function() {
                             this.setAttribute('data-user-selected', 'true');
                             this.classList.remove('input-error'); // remove red border if previously marked

                             const errorId = 'error_' + this.id;
                             const errorEl = document.getElementById(errorId);
                             if (errorEl) errorEl.style.display = 'none';
                         });
                     });
                     document.querySelectorAll('#form7mdaatfollowup input[type="range"]').forEach(slider => {
                         slider.addEventListener('input', function() {
                             this.setAttribute('data-user-selected', 'true');
                             this.classList.remove('input-error');

                             const errorId = 'error_' + this.id;
                             const errorEl = document.getElementById(errorId);
                             if (errorEl) errorEl.style.display = 'none';
                         });
                     });



                 });
             </script>
         </div>
     </div>
     </div>

     <script>
         const radios = document.querySelectorAll('.scale-radio');
         radios.forEach(radio => {
             radio.addEventListener('change', function() {
                 const parent = this.closest('.scale');
                 const labels = parent.querySelectorAll('.scale-btn');
                 labels.forEach(label => {
                     label.style.backgroundColor = '';
                 });
                 if (this.checked) {
                     this.nextElementSibling.style.backgroundColor = '#4CAF50';
                 }
             });
         });

         document.addEventListener("DOMContentLoaded", function() {
             function updateDoubledScore(section) {
                 let selectedRadioErythema = document.querySelector(`input[name="erythema${section}"]:checked`);
                 let selectedRadioDamage = document.querySelector(`input[name="damage${section}"]:checked`);
                 let resultField = document.getElementById(`doubled-score${section}`);
                 if (selectedRadioErythema) {
                     let value = parseInt(selectedRadioErythema.value) || 0;
                     resultField.value = value > 0 ? value * 2 : 0;
                 }
             }
             document.querySelectorAll('input[name="erythema1"], input[name="damage1"]').forEach(radio => {
                 radio.addEventListener("change", function() {
                     updateDoubledScore(1);
                 });
             });
             document.querySelectorAll('input[name="erythema2"], input[name="damage2"]').forEach(radio => {
                 radio.addEventListener("change", function() {
                     updateDoubledScore(2);
                 });
             });
             updateDoubledScore(1);
             updateDoubledScore(2);
         });

         document.querySelectorAll('.expand-btn').forEach(button => {
             button.addEventListener('click', function() {
                 let target = document.getElementById(this.dataset.target);
                 target.classList.add('fullscreen');
                 this.style.display = 'none';
                 target.querySelector('.minimize-btn').style.display = 'inline-block';
             });
         });

         document.querySelectorAll('.minimize-btn').forEach(button => {
             button.addEventListener('click', function() {
                 let target = document.getElementById(this.dataset.target);
                 target.classList.remove('fullscreen');
                 this.style.display = 'none';
                 target.querySelector('.expand-btn').style.display = 'inline-block';
             });
         });
     </script>
     <script>
         // Auto-save each form on any change
         $(document).ready(function() {
             $('form').on('change', 'input, select, textarea', function() {
                 const form = $(this).closest('form');
                 const formId = form.attr('id');
                 const caseId = $('input[name="case_no"]').val();

                 if (!formId || !caseId) return;

                 const formData = form.serializeArray();

                 $.ajax({
                     url: '<?php echo e(route('save.form.data')); ?>',
                     method: 'POST',
                     data: {
                         _token: '<?php echo e(csrf_token()); ?>',
                         form_id: formId,
                         case_id: caseId,
                         form_data: formData
                     },
                     success: function() {
                         $('#save-all-success-msg').stop(true, true).fadeIn().delay(1500)
                             .fadeOut();
                     },
                     error: function(xhr) {
                         console.warn('Autosave failed for', formId, ':', xhr.responseJSON
                             ?.message ?? 'Server error');
                     }
                 });
             });
         });
     </script>
 <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yxq9qmneoal1/public_html/novartistraining.gurukoolhub.com/resources/views/doctors/view-doc.blade.php ENDPATH**/ ?>