<?php
$formData = \App\Models\FormDraft::where([
'form_id' => 'form9cdasiactivity',
'case_id' => $case_no,
'user_id' => auth()->id()
])->first();

$scores = [];

if ($formData) {
$decoded = json_decode($formData->form_data, true);
$scores = $decoded['scores'] ?? [];
}
?>

<form id="form9cdasiactivity">
    <input type="hidden" name="form_id" value="form9cdasiactivity">
    <input type="hidden" name="case_no" value="<?php echo e($case_no); ?>">

    <div class="table-container1">
        <h3>Case Presentation: Follow up <br>
            <hr>Cutaneous Dermatomyositis Disease Area and Severity Index (CDASI)
        </h3>
        <h5 style="font-size: 15px;">Provide answers with the most appropriate responses based on the case review.
            Answer all questions.</h5>

        <table id="cdasi_follow_up_activity-table" class="table table-striped table-bordered mediaTable table-2">
            <h2
                style="background-color: #28a745; color: white; padding: 12px; border-radius: 5px; border: 2px solid #218838; text-align: center;">
                CDASI Activity</h2>

            <thead>
                <tr>
                     <th class="essential persist"><strong>Anatomical Location</strong></th>
                    <th class="optional" style="width: 150px;"><strong>Erythema</strong></th>
                    <th class="optional" style="width: 200px;"><strong>Scale</strong></th>
                    <th><strong>Erosion/Ulceration</strong></th>
                </tr>
                <tr>
                    
                    <th class="essential persist"></th>
                    <th class="optional" style="width: 150px; font-size: 12px;">
                        0 - absent <br>
                        1 - pink; faint erythema <br>
                        2 - red <br>
                        3 - dark red
                    </th>
                    <th class="optional" style="width: 200px; font-size: 12px;">
                        0 - absent <br>
                        1 - scale <br>
                        2 - crust; lichenification
                    </th>
                    <th style="font-size: 12px;">
                        0 - absent <br>
                        1 - present
                    </th>
                </tr>
            </thead>

            <tbody>
                <!-- Row 1 -->
                <tr class="section-2-sub">
                     <td><strong>Scalp</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_scalp_1]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_scalp_1']) && $scores['cdasi_activity_scalp_1'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_scalp_2]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_scalp_2']) && $scores['cdasi_activity_scalp_2'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_scalp_3]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_scalp_3']) && $scores['cdasi_activity_scalp_3'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>

                <!-- Row 2 -->
                <tr class="section-2-sub">
                     <td><strong>Malar Area</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_malar_area_1]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_malar_area_1']) && $scores['cdasi_activity_malar_area_1'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_malar_area_2]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_malar_area_2']) && $scores['cdasi_activity_malar_area_2'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_malar_area_3]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_malar_area_3']) && $scores['cdasi_activity_malar_area_3'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>

                <!-- Row 3 -->
                <tr class="section-2-sub">
                     <td><strong>Periorbital</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Periorbital_1]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Periorbital_1']) && $scores['cdasi_activity_Periorbital_1'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Periorbital_2]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Periorbital_2']) && $scores['cdasi_activity_Periorbital_2'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Periorbital_3]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Periorbital_3']) && $scores['cdasi_activity_Periorbital_3'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>

                <!-- Row 4 -->
                <tr class="section-2-sub">
                     <td><strong>Rest of the Face</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Rest_of_the_face_1]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Rest_of_the_face_1']) && $scores['cdasi_activity_Rest_of_the_face_1'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Rest_of_the_face_2]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Rest_of_the_face_2']) && $scores['cdasi_activity_Rest_of_the_face_2'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Rest_of_the_face_3]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Rest_of_the_face_3']) && $scores['cdasi_activity_Rest_of_the_face_3'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>

                <!-- Row 5 -->
                <tr class="section-2-sub">
                     <td><strong>V-area Neck (Frontal)</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_v-neck_frontal_1]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_v-neck_frontal_1']) && $scores['cdasi_activity_v-neck_frontal_1'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_v-neck_frontal_2]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_v-neck_frontal_2']) && $scores['cdasi_activity_v-neck_frontal_2'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_v-neck_frontal_3]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_v-neck_frontal_3']) && $scores['cdasi_activity_v-neck_frontal_3'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>

                <!-- Row 6 -->
                <tr class="section-2-sub">
                     <td><strong>Posterior Neck</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_posterior_neck_1]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_posterior_neck_1']) && $scores['cdasi_activity_posterior_neck_1'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_posterior_neck_2]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_posterior_neck_2']) && $scores['cdasi_activity_posterior_neck_2'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_posterior_neck_3]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_posterior_neck_3']) && $scores['cdasi_activity_posterior_neck_3'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>

                <!-- Row 7 -->
                <tr class="section-2-sub">
                     <td><strong>Upper Back & Shoulders</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_upper_back_shoulder_1]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_upper_back_shoulder_1']) && $scores['cdasi_activity_upper_back_shoulder_1'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_upper_back_shoulder_2]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_upper_back_shoulder_2']) && $scores['cdasi_activity_upper_back_shoulder_2'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_upper_back_shoulder_3]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_upper_back_shoulder_3']) && $scores['cdasi_activity_upper_back_shoulder_3'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>

                <!-- Row 8 -->
                <tr class="section-2-sub">
                     <td><strong>Rest of Back & Buttocks</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Rest_of_back_buttocks_1]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Rest_of_back_buttocks_1']) && $scores['cdasi_activity_Rest_of_back_buttocks_1'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Rest_of_back_buttocks_2]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Rest_of_back_buttocks_2']) && $scores['cdasi_activity_Rest_of_back_buttocks_2'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Rest_of_back_buttocks_3]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Rest_of_back_buttocks_3']) && $scores['cdasi_activity_Rest_of_back_buttocks_3'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>

                <!-- Row 9 -->
                <tr class="section-2-sub">
                     <td><strong>Abdomen</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Abdomen_1]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Abdomen_1']) && $scores['cdasi_activity_Abdomen_1'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Abdomen_2]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Abdomen_2']) && $scores['cdasi_activity_Abdomen_2'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Abdomen_3]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Abdomen_3']) && $scores['cdasi_activity_Abdomen_3'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>

                <!-- Row 10 -->
                <tr class="section-2-sub">
                     <td><strong>Lateral Upper Thigh</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Lateral_upper_thigh_1]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Lateral_upper_thigh_1']) && $scores['cdasi_activity_Lateral_upper_thigh_1'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Lateral_upper_thigh_2]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Lateral_upper_thigh_2']) && $scores['cdasi_activity_Lateral_upper_thigh_2'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Lateral_upper_thigh_3]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Lateral_upper_thigh_3']) && $scores['cdasi_activity_Lateral_upper_thigh_3'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>

                <!-- Row 11 -->
                <tr class="section-2-sub">
                     <td><strong>Rest of Leg & Feet</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Rest_of_leg_feet_1]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Rest_of_leg_feet_1']) && $scores['cdasi_activity_Rest_of_leg_feet_1'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Rest_of_leg_feet_2]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Rest_of_leg_feet_2']) && $scores['cdasi_activity_Rest_of_leg_feet_2'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Rest_of_leg_feet_3]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Rest_of_leg_feet_3']) && $scores['cdasi_activity_Rest_of_leg_feet_3'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>

                <!-- Row 12 -->
                <tr class="section-2-sub">
                     <td><strong>Arm</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Arm_1]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Arm_1']) && $scores['cdasi_activity_Arm_1'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Arm_2]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Arm_2']) && $scores['cdasi_activity_Arm_2'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Arm_3]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Arm_3']) && $scores['cdasi_activity_Arm_3'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>

                <!-- Row 13 -->
                <tr class="section-2-sub">
                     <td><strong>Mechanic's Hand</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Mechanic_hand_1]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Mechanic_hand_1']) && $scores['cdasi_activity_Mechanic_hand_1'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Mechanic_hand_2]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Mechanic_hand_2']) && $scores['cdasi_activity_Mechanic_hand_2'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Mechanic_hand_3]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Mechanic_hand_3']) && $scores['cdasi_activity_Mechanic_hand_3'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>

                <!-- Row 14 -->
                <tr class="section-2-sub">
                     <td><strong>Dorsum of Hands (Not Over Joints)</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Dorsum_of_hand_1]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Dorsum_of_hand_1']) && $scores['cdasi_activity_Dorsum_of_hand_1'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Dorsum_of_hand_2]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Dorsum_of_hand_2']) && $scores['cdasi_activity_Dorsum_of_hand_2'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Dorsum_of_hand_3]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Dorsum_of_hand_3']) && $scores['cdasi_activity_Dorsum_of_hand_3'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>

                <!-- Row 15 -->
                <tr class="section-2-sub">
                     <td><strong>Gottron's - Not on Hands</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Gottrons_not_on_hand_1]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Gottrons_not_on_hand_1']) && $scores['cdasi_activity_Gottrons_not_on_hand_1'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Gottrons_not_on_hand_2]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Gottrons_not_on_hand_2']) && $scores['cdasi_activity_Gottrons_not_on_hand_2'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[cdasi_activity_Gottrons_not_on_hand_3]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['cdasi_activity_Gottrons_not_on_hand_3']) && $scores['cdasi_activity_Gottrons_not_on_hand_3'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>

        <br>
       <!--  <button type="button" class="btn btn-success save-btn" data-form-id="form9cdasiactivity">📝 Save Draft</button>
        <span class="save-success-msg text-success" style="margin-left: 15px; font-weight: bold; display: none;">
            ✔ Draft saved successfully
        </span> -->
    </div>
</form><?php /**PATH /home/yxq9qmneoal1/public_html/novartistraining.gurukoolhub.com/resources/views/doctors/forms/form9CDASIActivity.blade.php ENDPATH**/ ?>