<?php
$formData = \App\Models\FormDraft::where([
'form_id' => 'form3cdasi',
'case_id' => $case_no,
'user_id' => auth()->id()
])->first();

$scores = [];

if ($formData) {
$decoded = json_decode($formData->form_data, true);
$scores = $decoded['scores'] ?? [];
}
?>

<form id="form3cdasi">
    <input type="hidden" name="form_id" value="form3cdasi">
    <input type="hidden" name="case_no" value="<?php echo e($case_no); ?>">

    <div class="table-container">
        <h3>Case  Presentation: Initial <br>
            <hr>Cutaneous Dermatomyositis Disease Area and Severity Index (CDASI)
        </h3>
        <h5 style="font-size: 15px;">Provide answers with the most appropriate responses based on the case review.
            Answer all questions.</h5>

        <table id="activity-table" class="table table-striped table-bordered mediaTable table-1">
            <h2
                style="background-color: #28a745; color: white; padding: 12px; border-radius: 5px; border: 2px solid #218838; text-align: center;">
                CDASI Activity</h2>

            <thead> 
                <tr>

 
                    <th class="essential persist"><strong>Anatomical Location</strong></th>
                    <th class="optional" style="width: 150px;"><strong>Erythema</strong>

                    </th>


                    <th class="optional" style="width: 200px;"><strong>Scale</strong>



                    </th>

                    <th><strong>Erosion/Ulceration</strong>


                </tr>


                <tr>

 
                    <th class="essential persist"></th>
                    <th class="optional" style="width: 150px; font-size: 12px;">
                        0 - absent <br>
                        1 - pink; faint erythema <br>
                        2 - red <br>
                        3 - dark red

                    </th>


                    <th class="optional" style="width: 200px; font-size: 12px;">

                        0 - absent <br>



                        1 - scale <br>



                        2 - crust; lichenification

                    </th>

                    <th style="font-size: 12px;">

                        0 - absent <br>



                        1 - present</th>

                </tr>

            </thead>

            <tbody>
                <!-- Example: Row 1 -->
                <tr class="section-1-sub">
                     <td><strong>Scalp</strong> </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[activity-radio1]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['activity-radio1']) && $scores['activity-radio1'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[activity-radio2]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['activity-radio2']) && $scores['activity-radio2'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[activity-radio3]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['activity-radio3']) && $scores['activity-radio3'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>
                <tr class="section-1-sub">
                     <td><strong>Malar Area</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[activity-radio4]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['activity-radio4']) && $scores['activity-radio4'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[malar_middle_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['malar_middle_initia_cdasi']) && $scores['malar_middle_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[malar_right_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['malar_right_initia_cdasi']) && $scores['malar_right_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>
                <tr class="section-1-sub">
                     <td><strong>Periorbital</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[Periorbital_left_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['Periorbital_left_initia_cdasi']) && $scores['Periorbital_left_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[Periorbital_middle_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['Periorbital_middle_initia_cdasi']) && $scores['Periorbital_middle_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[Periorbital_right_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['Periorbital_right_initia_cdasi']) && $scores['Periorbital_right_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>
                <tr class="section-1-sub">
                     <td><strong>Rest of the Face</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[restofface_left_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['restofface_left_initia_cdasi']) && $scores['restofface_left_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[restofface_middle_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['restofface_middle_initia_cdasi']) && $scores['restofface_middle_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[restofface_right_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['restofface_right_initia_cdasi']) && $scores['restofface_right_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>
                <tr class="section-1-sub">
                     <td><strong>V-area Neck (Frontal)</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[vareaneck_left_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['vareaneck_left_initia_cdasi']) && $scores['vareaneck_left_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[vareaneck_middle_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['vareaneck_middle_initia_cdasi']) && $scores['vareaneck_middle_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[vareaneck_right_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['vareaneck_right_initia_cdasi']) && $scores['vareaneck_right_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>
                <tr class="section-1-sub">
                     <td><strong>Posterior Neck</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[posterior_left_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['posterior_left_initia_cdasi']) && $scores['posterior_left_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[posterior_middle_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['posterior_middle_initia_cdasi']) && $scores['posterior_middle_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[posterior_right_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['posterior_right_initia_cdasi']) && $scores['posterior_right_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>
                <tr class="section-1-sub">
                     <td><strong>Upper Back & Shoulders</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[upperbackshoulder_left_initia_cdasi]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['upperbackshoulder_left_initia_cdasi']) && $scores['upperbackshoulder_left_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[upperbackshoulder_middle_initia_cdasi]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['upperbackshoulder_middle_initia_cdasi']) && $scores['upperbackshoulder_middle_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[upperbackshoulder_right_initia_cdasi]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['upperbackshoulder_right_initia_cdasi']) && $scores['upperbackshoulder_right_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>
                <tr class="section-1-sub">
                     <td><strong>Rest of Back & Buttocks</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[restofbackbuttocks_left_initia_cdasi]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['restofbackbuttocks_left_initia_cdasi']) && $scores['restofbackbuttocks_left_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[restofbackbuttocks_middle_initia_cdasi]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['restofbackbuttocks_middle_initia_cdasi']) && $scores['restofbackbuttocks_middle_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[restofbackbuttocks_ritgh_initia_cdasi]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['restofbackbuttocks_ritgh_initia_cdasi']) && $scores['restofbackbuttocks_ritgh_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>
                <tr class="section-1-sub">
                     <td><strong>Abdomen</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[abdomen_left_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['abdomen_left_initia_cdasi']) && $scores['abdomen_left_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[abdomen_middle_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['abdomen_middle_initia_cdasi']) && $scores['abdomen_middle_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[abdomen_right_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['abdomen_right_initia_cdasi']) && $scores['abdomen_right_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>
                <tr class="section-1-sub">
                     <td><strong>Lateral Upper Thigh</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[lateralupperthigh_left_initia_cdasi]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['lateralupperthigh_left_initia_cdasi']) && $scores['lateralupperthigh_left_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[lateralupperthigh_middle_initia_cdasi]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['lateralupperthigh_middle_initia_cdasi']) && $scores['lateralupperthigh_middle_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[lateralupperthigh_right_initia_cdasi]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['lateralupperthigh_right_initia_cdasi']) && $scores['lateralupperthigh_right_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>
                <tr class="section-1-sub">
                     <td><strong>Rest of Leg & Feet</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[restoflegfeet_left_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['restoflegfeet_left_initia_cdasi']) && $scores['restoflegfeet_left_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[restoflegfeet_middle_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['restoflegfeet_middle_initia_cdasi']) && $scores['restoflegfeet_middle_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[restoflegfeet_right_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['restoflegfeet_right_initia_cdasi']) && $scores['restoflegfeet_right_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>
                <tr class="section-1-sub">
                     <td><strong>Arm</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[arm_left_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['arm_left_initia_cdasi']) && $scores['arm_left_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[arm_middle_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['arm_middle_initia_cdasi']) && $scores['arm_middle_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[arm_right_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['arm_right_initia_cdasi']) && $scores['arm_right_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>
                <tr class="section-1-sub">
                     <td><strong>Mechanic's Hand</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[mechanichand_left_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['mechanichand_left_initia_cdasi']) && $scores['mechanichand_left_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[mechanichand_middle_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['mechanichand_middle_initia_cdasi']) && $scores['mechanichand_middle_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[mechanichand_right_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['mechanichand_right_initia_cdasi']) && $scores['mechanichand_right_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>
                <tr class="section-1-sub">
                     <td><strong>Dorsum of Hands (Not Over Joints)</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[dorsumofhands_left_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['dorsumofhands_left_initia_cdasi']) && $scores['dorsumofhands_left_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[dorsumofhands_middle_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['dorsumofhands_middle_initia_cdasi']) && $scores['dorsumofhands_middle_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[dorsumofhands_right_initia_cdasi]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['dorsumofhands_right_initia_cdasi']) && $scores['dorsumofhands_right_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>
                <tr class="section-1-sub">
                     <td><strong>Gottron's - Not on Hands</strong></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2,3]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[gottronNotonHands_left_initia_cdasi]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['gottronNotonHands_left_initia_cdasi']) && $scores['gottronNotonHands_left_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1,2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[gottronNotonHands_middle_initia_cdasi]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['gottronNotonHands_middle_initia_cdasi']) && $scores['gottronNotonHands_middle_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = [0,1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[gottronNotonHands_right_initia_cdasi]"
                                    value="<?php echo e($val); ?>"
                                    <?php echo e(isset($scores['gottronNotonHands_right_initia_cdasi']) && $scores['gottronNotonHands_right_initia_cdasi'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>

        <br>
       <!--  <button type="button" class="btn btn-success save-btn" data-form-id="form3cdasi">📝 Save Draft</button>
        <span class="save-success-msg text-success" style="margin-left: 15px; font-weight: bold; display: none;">
            ✔ Draft saved successfully
        </span> -->
    </div>
</form><?php /**PATH E:\Case Management Software\21Aprilupdated\resources\views/doctors/forms/form3CDASI.blade.php ENDPATH**/ ?>