

<?php $__env->startSection('content'); ?> 
<br><br><br>

<div class="container">
    <h2 class="text-center">Assigned Cases</h2>
    
    <table class="table table-bordered table-hover">
        <thead class="table-dark text-center">
            <tr>
                <th>#</th>
                <th>Assigned Users</th>
                <th>Case Title</th>
                <th>Assigned Date & Time</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $assignedCases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $case): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="text-center"><?php echo e($key + 1); ?></td>

                    <!-- ✅ Display multiple assigned users in one row -->
                    <td class="fw-bold">
                        <?php if($case->users->isNotEmpty()): ?>
                            <?php echo e($case->users->pluck('username')->join(', ')); ?>

                        <?php else: ?>
                            <span class="text-danger">No Users Assigned</span>
                        <?php endif; ?>
                    </td>

                    <td><?php echo e($case->title); ?></td>

                    <!-- ✅ Show assigned date if available -->
                    <td class="text-center">
                        <?php if($case->users->isNotEmpty()): ?>
                            <?php echo e(\Carbon\Carbon::parse($case->users->first()->pivot->assigned_at)->format('d M Y, h:i A')); ?>

                        <?php else: ?>
                            N/A
                        <?php endif; ?>
                    </td>

                    <!-- ✅ Status -->
                    <td class="text-center">
                        <?php if($case->users->isNotEmpty()): ?>
                            <span class="text-success fw-bold">✅ Assigned</span>
                        <?php else: ?>
                            <span class="text-danger fw-bold">❌ Unassigned</span>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php if($assignedCases->isEmpty()): ?>
                <tr>
                    <td colspan="5" class="text-center text-muted">No assigned cases found</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yxq9qmneoal1/public_html/novartistraining.gurukoolhub.com/resources/views/admin/assigned_cases.blade.php ENDPATH**/ ?>