<?php
    use App\Models\FormDraft;

    $formData = FormDraft::where('user_id', auth()->id())
        ->where('form_id', 'form6pgda')
        ->where('case_id', $case_no)
        ->first();

    $savedValue = $formData ? json_decode($formData->form_data, true)['scores']['physician_global_activity'] ?? null : null;
    $initialValue = $savedValue !== null ? $savedValue : 0; // Show thumb at 0
    $isValueSet = $savedValue !== null ? 'true' : 'false';
?>

<form id="form6pgda" class="scoring-form" data-form-id="form6pgda" onsubmit="return validateSlider();">
    <div class="table-container">
        <section>
            <h3>Case Presentation: Initial
                <hr>Physician Global Disease Activity
            </h3>

            <h5>Please rate patient's global (overall) disease activity</h5><br>
            <span style="text-align:justify; font-size:14px">
                Disease Activity is defined as potentially reversible pathology or physiology resulting from the myositis...
            </span>
            <br><br>

            <div class="slider-section text-center">
                <div class="text-center" style="margin-top: 10px;">
                    Selected Value: <strong id="sliderValue"><?php echo e($savedValue !== null ? $savedValue : '--'); ?></strong>
                    <input type="hidden" id="hiddenSliderValue" name="input_types[physician_global_activity]" value="<?php echo e($savedValue); ?>">
                </div>

                <input type="range" class="form-control" id="activitySlider" name="scores[physician_global_activity]"
                    min="0" max="10" value="<?php echo e($initialValue); ?>" data-user-selected="<?php echo e($isValueSet); ?>"
                    oninput="
                        document.getElementById('sliderValue').innerText = this.value;
                        document.getElementById('hiddenSliderValue').value = this.value;
                        this.dataset.userSelected = 'true';
                        document.getElementById('sliderError').style.display = 'none';
                        this.classList.remove('is-invalid');
                    "
                    style="width: 100%; accent-color: #007bff;">

                <div class="row" style="margin-bottom: 10px;">
                    <div class="col-xs-4 text-left">No Evidence of Disease Activity</div>
                    <div class="col-xs-4 text-center">Moderate Disease Activity</div>
                    <div class="col-xs-4 text-right">Extremely Active or Severe Disease Activity</div>
                </div>

                <div id="sliderError" class="text-danger" style="display: none; font-weight: bold;">
                    Please select a value before submitting.
                </div>
            </div>
        </section>
    </div>
</form>

<script>
    function validateSlider() {
        const slider = document.getElementById('activitySlider');
        const userSet = slider.dataset.userSelected;

        if (userSet !== 'true') {
            document.getElementById('sliderError').style.display = 'block';
            slider.classList.add('is-invalid');
            slider.scrollIntoView({ behavior: 'smooth', block: 'center' });
            return false;
        }
        return true;
    }
</script>

<style>
    input[type=range].is-invalid {
        border: 2px solid #dc3545;
        outline: none;
    }
</style>
<?php /**PATH E:\Case Management Software\21Aprilupdated\resources\views/doctors/forms/form6PGDA.blade.php ENDPATH**/ ?>